#!/usr/bin/env python

import math, sys, os, string

gnu=open("plot.gnu",'w')
gnu.write("set encoding iso_8859_1\n")
gnu.write("set xlabel \'{/Symbol n}_{CPMG} (Hz)\' \n")
gnu.write("set ylabel \'R@_2^{eff} (s^{-1})\' \n")
gnu.write("set term post enh color solid 18\n")
gnu.write("set out \'%s\' \n" % ("cpmg.ps"))

for file in range(len(sys.argv)-1):
    # Get name of the peak
    Name=string.split(string.strip(sys.argv[file+1]),'.')[0]
    gnu.write("plot \'%s\' i 0 u 1:2:3 t \'%s\' w e pt 6 ps 2 lt 1, '' i 0 u 1:4 t \'\' w lines lt 1, \\\n" % (Name+".dat",Name+"/500"))
    gnu.write("\'%s\' i 1 u 1:2:3 t \'%s\' w e pt 6 ps 2 lt 3, '' i 1 u 1:4 t \'\' w lines lt 3\n" % (Name+".dat",Name+"/800"))

gnu.close()

os.system("/usr/bin/gnuplot plot.gnu")
os.system('sed -e \"/gnulinewidth 5.000 def/s//gnulinewidth 12.000 def/" cpmg.ps > _t')
os.system('/bin/mv _t cpmg.ps')

